IF EXISTS
(
    SELECT *
    FROM sys.views
    WHERE object_id = OBJECT_ID(N'[dbo].V_PDV_CX_CARGA_TENTACLE')
)
    DROP VIEW [dbo].[V_PDV_CX_CARGA_TENTACLE];
GO

CREATE VIEW V_PDV_CX_CARGA_TENTACLE
AS
SELECT CX.CD_EMP
	  ,CX.CD_FILIAL
	  ,CX.NM_TERM
	  ,CX.CD_CX
	  ,CX.PORTA_IMP
	  ,CX.PORTA_BLNC
	  ,CX.VEL_COM_BLNC
	  ,CX.STS_PDV
	  ,CX.MDL_IMP_FC
	  ,CX.NR_SERIE_IMP
	  ,ISNULL(CX.ID_TERM_TEF, '') AS ID_TERM_TEF
	  ,ISNULL(CX.TIPO_ECF, '') AS TIPO_ECF
	  ,ISNULL(CX.MARCA_ECF, '') AS MARCA_ECF
	  ,ISNULL(CX.MODELO_ECF, '') AS MODELO_ECF
	  ,CX.VERSAO_SOFTWARE_BASICO
	  ,CX.DATA_GRAVACAO_SOFTWARE_BASICO
	  ,CX.HORA_GRAVACAO_SOFTWARE_BASICO
	  ,CX.NR_PROPIETARIO_ECF
	  ,CX.FLAG_DESCONTO_ISS
	  ,CX.CODIGO_NACIONAL_IDENTIFICACAO_ECF
	  ,CX.REG_ALTERADO
	  ,ISNULL(CX.UTIL_GAV, 0) AS UTIL_GAV
	  ,ISNULL(CX.UTIL_BLNC, 0) AS UTIL_BLNC
	  ,0 AS alt_sist
	  ,0 AS ativado
	  ,0 AS bloq_tef
	  ,'' AS caminho_pasta_input_mfe
	  ,'' AS caminho_pasta_output_mfe
	  ,'' AS cgc
	  ,'' AS cod_ativacao_mfe
	  ,0 AS emissor
	  ,0 AS espaco_entre_cupons
	  ,0 AS flag_consolidado
	  ,0 AS flag_vd_serv
	  ,'' AS host_name
	  ,'' AS ip_caixa
	  ,'' AS letra_mf_adicional
	  ,0 AS manter_conexao_online_ativa
	  ,'' AS nr_serie_imp_crypt
	  ,'' AS reg_hash
	  ,'' AS script_executado
	  ,'' AS signacmfe
	  ,0 AS tp_conexao_online
	  ,0 AS valida_imp
	  ,'' AS vl_gt_imp_crypt
	  ,CX.POS_QR_LINX
	  ,CX.EXIBE_QRLINX_TELA
 FROM PDV_CX CX
	  LEFT JOIN PDV_CX_EST_NF_SERIE CX_SERIE ON CX.CD_CTR_SERIE = CX_SERIE.CD_CTR
	  LEFT JOIN EST_NF_SERIE SERIE ON CX_SERIE.CD_EMP = SERIE.CD_EMP
								  AND CX_SERIE.CD_NF_SERIE = SERIE.CD_NF_SERIE
								  AND (SERIE.TP_SR_NFE = 1)
								  AND (SERIE.COD_MODELO = '65')
								  AND (SERIE.ESPC = 'NFE')
 WHERE CX.CD_EMP = 1

GO